﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using HospitalModel;
using System.Data.Objects;
using System.Data.Common;
using HospitalModel;

namespace HospitalModel
{
    class Program
    {
        static void Main(string[] args)
        {
            SelectEntitySql();
            //SelectCustomEntity();
            //PerformLINQQuery();
            //AddNewDoctor();
            //UpdateDoctor();
            //DeleteDoctor();

            Console.ReadKey();
        }

        private static void DeleteDoctor()
        {
            using (var custHospital = new CustomHospitalEntities())
            {
                var doctors =
                    from doc in custHospital.Doctors
                    where doc.Name == "90210"
                    select doc;

                doctors.ToList().ForEach(
                    doc => custHospital.DeleteObject(doc));

                custHospital.SaveChanges();

                foreach (var doc in custHospital.Doctors)
                {
                    Console.WriteLine("Name: {0}", doc.Name);
                }
            }
        }

        private static void UpdateDoctor()
        {
            using (var custHospital = new CustomHospitalEntities())
            {
                var doctors =
                    from doc in custHospital.Doctors
                    where doc.Name == "90210"
                    select doc;

                var doctor = doctors.FirstOrDefault();

                doctor.Name += "-0000";

                custHospital.SaveChanges();

                foreach (var doc in custHospital.Doctors)
                {
                    Console.WriteLine("Name: {0}", doc.Name);
                }
            }
        }

        private static void AddNewDoctor()
        {
            using (var custHospital = new CustomHospitalEntities())
            {
                custHospital.AddToDoctors(
                    new Doctor
                    {
                        Name = "90210"
                    }
                );

                custHospital.SaveChanges();

                foreach (var doc in custHospital.Doctors)
                {
                    Console.WriteLine("Name: {0}", doc.Name);
                }
            }
        }

        private static void PerformLINQQuery()
        {
            using (var custHospital = new CustomHospitalEntities())
            {
                var doctors =
                    from doc in custHospital.Doctors
                    select doc;

                foreach (var doc in doctors)
                {
                    Console.WriteLine("Name: {0}", doc.Name);
                }
            }
        }

        private static void SelectCustomEntity()
        {
            using (var custHospital = new CustomHospitalEntities())
            {
                ObjectQuery<Doctor> doctorQuery =
                    new ObjectQuery<Doctor>(
                        "select value Doc from CustomHospitalEntities.Doctors as Doc",
                        custHospital);

                foreach (var doc in doctorQuery)
                {
                    Console.WriteLine("Name: {0}", doc.Name);
                }
            }
        }

        private static void SelectEntitySql()
        {
            using (var hospital = new HospitalEntities())
            {
                //ObjectQuery<HospitalStaff> hospitalStaffQuery =
                //    new ObjectQuery<HospitalStaff>(
                //        "select value Staff from HospitalEntities.HospitalStaff as Staff where Staff.Position = 'Doctor'",
                //        hospital);

                ObjectQuery<DbDataRecord> hospitalStaffQuery =
                    new ObjectQuery<DbDataRecord>(
                        "select Staff.Name, Staff.Position from HospitalEntities.HospitalStaff as Staff where Staff.Position = 'Doctor'",
                        hospital);
                
                foreach (var doc in hospitalStaffQuery)
                {
                    Console.WriteLine("Doctor: {0}", doc.GetString(0));
                }
            }
        }
    }
}
